/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.mixin.client;

import cgcm.chestsearchbar.SearchHandler;
import cgcm.chestsearchbar.config.Config;
import cgcm.chestsearchbar.config.Mode;
import cgcm.chestsearchbar.gui.SearchBox;
import cgcm.chestsearchbar.input.Keybindings;
import cgcm.chestsearchbar.util.ContainerUtil;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin<T extends class_1703>
extends class_437
implements class_3936<T> {
    @Shadow
    protected final T field_2797;
    @Shadow
    protected int field_2792;
    @Shadow
    protected int field_25267;
    @Shadow
    protected int field_25268;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected class_1735 field_2787;
    @Unique
    private SearchHandler searchHandler;
    @Unique
    private static long lastClick;

    @Shadow
    protected abstract boolean method_2378(int var1, int var2, int var3, int var4, double var5, double var7);

    @Shadow
    protected abstract boolean method_2387(class_1735 var1, double var2, double var4);

    protected AbstractContainerScreenMixin(T menu, class_2561 pTitle) {
        super(pTitle);
        this.field_2797 = menu;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo callbackinfo) {
        int pX;
        int barWidth;
        class_465 instance = (class_465)this;
        Mode mode = Config.getMode(instance, ContainerUtil.getMenuSize(((class_1703)this.field_2797).field_7761.size()));
        if (instance instanceof class_481 || instance instanceof class_490 || instance instanceof class_479 || mode == Mode.DISABLED) {
            return;
        }
        int pY = this.field_2800 + this.field_25268;
        if (Config.detachSearchBar) {
            barWidth = (int)((double)this.field_2792 * 0.6);
            pX = this.field_22789 / 2 - barWidth / 2;
            pY = Math.max(pY - 20, 1);
        } else {
            pX = this.field_2776 + this.field_25267 + (this.field_22785.getString().isBlank() ? 0 : this.field_22793.method_1727(this.field_22785.getString().replaceAll("\\p{C}", "")) + 3);
            int finalPos = this.field_2776 + this.field_2792 - this.field_25267;
            pX = Math.min(pX, finalPos - 32);
            barWidth = finalPos - pX + 1;
        }
        SearchBox searchBar = new SearchBox(this.field_22793, pX + 1, pY, barWidth, 9, Config.detachSearchBar);
        this.searchHandler = new SearchHandler(instance, searchBar, mode);
        this.method_25429((class_364)searchBar);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler == null) {
            return;
        }
        this.searchHandler.getSearchBar().method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!this.searchHandler.shouldUseSearch() || !this.searchHandler.isSortMode()) {
            return;
        }
        for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
            class_1735 posSlot = this.field_2797.method_7611(i);
            if (!this.method_2378(posSlot.field_7873, posSlot.field_7872, 16, 16, pMouseX, pMouseY) || !posSlot.method_7682()) continue;
            this.field_2787 = i < this.searchHandler.getSearchResult().size() ? this.searchHandler.getSearchResult().get(i) : null;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)})
    private void onRenderLabels(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        if (this.searchHandler != null && this.searchHandler.shouldUseSearch() && !this.searchHandler.isSortMode()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                class_1735 posSlot = this.field_2797.method_7611(i);
                if (this.searchHandler.getSearchResult().contains(posSlot)) continue;
                pGuiGraphics.method_51740(class_1921.method_51785(), posSlot.field_7873, posSlot.field_7872, posSlot.field_7873 + 16, posSlot.field_7872 + 16, -1275068416, -1275068416, 0);
            }
        }
    }

    @Redirect(method={"renderSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;getItem()Lnet/minecraft/world/item/ItemStack;"))
    private class_1799 redirectGetItem(class_1735 slot) {
        int index = slot.field_7874;
        if (this.searchHandler == null || !this.searchHandler.shouldUseSearch() || !this.searchHandler.isSortMode() || index >= this.searchHandler.getMenuSize()) {
            return slot.method_7677();
        }
        if (this.searchHandler.getSearchResult().size() > index) {
            return this.searchHandler.getSearchResult().get(index).method_7677();
        }
        return class_1799.field_8037;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (!this.searchHandler.getSearchBar().method_25405(pMouseX, pMouseY)) {
                this.searchHandler.getSearchBar().method_25365(false);
            } else {
                long time = System.currentTimeMillis();
                long d = time - lastClick;
                if (d < 200L && this.searchHandler.getSearchBar().method_25370() && !this.searchHandler.isBarEmpty()) {
                    this.searchHandler.getSearchBar().method_1852("");
                    SearchHandler.search = "";
                }
                lastClick = time;
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchHandler != null) {
            if (this.searchHandler.getSearchBar().method_25370()) {
                if (pKeyCode != 256 && this.searchHandler.getSearchBar().method_1885()) {
                    this.searchHandler.getSearchBar().method_25404(pKeyCode, pScanCode, pModifiers);
                    cir.setReturnValue((Object)true);
                }
            } else if (Keybindings.TOGGLE_SEARCH_BAR_KEY.method_1417(pKeyCode, pScanCode)) {
                boolean v = !this.searchHandler.getSearchBar().method_1885();
                this.searchHandler.getSearchBar().method_1862(v);
                SearchHandler.enabled = v;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.searchHandler != null) {
            this.searchHandler.tick();
        }
    }

    @Inject(method={"findSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void findSlot(double pMouseX, double pMouseY, CallbackInfoReturnable<class_1735> cir) {
        if (this.searchHandler != null && this.searchHandler.isSortMode() && this.searchHandler.shouldUseSearch()) {
            for (int i = 0; i < this.searchHandler.getMenuSize(); ++i) {
                class_1735 slot = this.field_2797.method_7611(i);
                if (!this.method_2387(slot, pMouseX, pMouseY) || !slot.method_7682()) continue;
                if (i < this.searchHandler.getSearchResult().size()) {
                    cir.setReturnValue((Object)this.searchHandler.getSearchResult().get(i));
                    continue;
                }
                cir.setReturnValue(null);
            }
        }
    }
}

